#define IDM_EINSTELLUNGEN                1000
#define IDM_E_DISPLAYHOEHER              1010
#define IDM_E_DISPLAYBREITER             1020
#define IDM_E_DISPLAYNIEDRIGER           1030
#define IDM_E_DISPLAYSCHMAELER           1040
#define IDM_E_FONTSELECTION              1050
#define IDM_E_DISTRACTORMATERIAL         1150
#define IDM_E_TARGETMATERIAL             1155
#define IDM_E_RESULTSFILENAME            1160
#define IDM_E_CALIBRATESPEEDDOWN         1165
#define IDM_E_CALIBRATESPEEDUP           1170
#define IDM_INTERN_CALIBRATIONSTEP       1180
#define IDM_E_HANDSTART                  1200

#define IDM_T_TIMERRESOLUTION            1250
#define IDM_T_DISPMETRICS                1300
#define IDM_T_ISD                        1350
#define IDM_T_HERVOREINTRITT             1400
#define IDM_T_HERVORHOEHE                1450
#define IDM_T_BEENDEN                    1500

#define IDM_INTRO                        1550

#define UD_WRITEOUTDATA                  (WM_USER+2)
#define UD_UNDOAUTISM                    (WM_USER+3)

// Dialog zum Einstellen von StartTC und EndTC
//#define RUN_BEGIN_EDI                    101
//#define RUN_END_EDI                      102
//#define static_1                         103
//#define static_2                         104

#define AWAITNTIMERS                     72     // Number of scroll steps before new string is dropped, must be a multiple of 2
#define AUSGLEICH                        5      // Do not change this constant

#define NUMBEROFRESULTSLOTS              1000L  // # of slots in results vector

// Zustandsberwachung Drucktaster
//#define TASTERUNTEN  TRUE
//#define TASTEROBEN   FALSE

#define IDS_ERR_REGISTER_CLASS           1
#define IDS_ERR_CREATE_WINDOW            2
#define IDS_ERR_WAVELOAD                 3
#define IDS_ERR_LoadMemImagesOfS_0       4
#define IDS_ERR_LoadMemImagesOfS_1       5
#define IDS_ERR_LoadMemImagesOfS_2       6
#define IDS_ERR_LoadMemImagesOfS_3       7
#define IDS_ERR_LoadMemImagesOfS_4       8

//#define SCROLLBARIDENTIFIER              1
//#define LABEL1IDENTIFIER                 2
//#define LABEL2IDENTIFIER                 3

enum {CALGRAY_PINDEX=0,PUREGREEN_PINDEX,PALEYELLOW_PINDEX}; // For color palette access
typedef enum {HOEHER,BREITER,NIEDRIGER,SCHMAELER} RESIZETYPE;

// Flags in DISPLAYNODE
// Kommando-Flags aus dem Steuerskript
#define DROPTEXT                         0x0001 // 0000 0000 0000 0001
#define TRUELOUDTARGETHIGHLIGHT          0x0002 // 0000 0000 0000 0010 
#define SILENTTARGETHIGHLIGHT            0x0004 // 0000 0000 0000 0100
#define LOUDDISTRACTHIGHLIGHT            0x0008 // 0000 0000 0000 1000 
#define SILENTDISTRACTHIGHLIGHT          0x0010 // 0000 0000 0001 0000
#define PREMATUREWARNEDTARGETHIGHLIGHT   0x0020 // 0000 0000 0010 0000
#define TERMINATETRIAL                   0x0040 // 0000 0010 0100 0000
// Interne Info-Flags
#define BEENHIGHLIGHTED          0x0100 // 0000 0001 0000 0000
#define BEENRENORMALIZED         0x0200 // 0000 0010 0000 0000
#define BEENDEADCOLORED          0x0400 // 0000 0100 0000 0000
#define BEENPREMATURESIRENED     0x0800 // 0000 1000 0000 0000

#define READ_TIMEOUT             10 // 10 msec serial communication timeout 

typedef struct TIMEONLY_tag {                      // Packed BCD format
   BYTE bcdSt;                                     // Hours
   BYTE bcdMi;                                     // Minutes
   BYTE bcdSe;                                     // Seconds
   BYTE bcdFr;                                     // Frames
} TIMEONLY;

typedef struct INTFORMTC_tag {
   int intSt;                                      // Hours
   int intMi;                                      // Minutes
   int intSe;                                      // Seconds
   int intFr;                                      // Frames
} INTFORMTC;

typedef struct TEXTDISPLAYNODE_tag {
  INTFORMTC dropTime;          // 8 Byte, 
  int age;                     // 2 Byte
  WORD flags;                  // 2 Byte
  char text[128];              // 128 Byte
} TEXTDISPLAYNODE;

typedef TEXTDISPLAYNODE  * HP_TEXTDISPLAYNODE;

typedef struct RESULTSNODE_tag {
  DWORD runTime;          // Time since trial start in msec
  TIMEONLY videoTC;       // Video Time Code
  char text[128];         // Stimulus material
  char reactionType[12];  // "hit" or "false alarm" or nothing (you can just drop a sound)
} RESULTSNODE;

typedef RESULTSNODE  * HP_RESULTSNODE;

//typedef enum {
//	Easy,
//	Middle,
//	Hard
//} STATIC_SITUATION_COMPLEXITY;

char szString[124];
char szAppName[20];
char szDispWndName[20];
HINSTANCE hInst;
HWND hWndMain;
HACCEL hAccel;

LRESULT CALLBACK WndProc(HWND,WORD,WORD,LONG);
LONG FAR PASCAL DispWndProc(HWND,WORD,WORD,LONG);
BOOL FAR PASCAL StartEndMsgProc(HWND hWndDlg,WORD Message,WORD wParam,LONG lParam);

void cwCenterChild(HWND hWnd,int top);
void SizeWindow(HWND hWnd,RESIZETYPE resize);
int nCwRegisterClasses(void);
void CwUnRegisterClasses(void);
void GetINCAR6ProfileData(void);
void WriteINCAR6ProfileData(void);
void MakeDistractorMaterialTable(void);
void MakeTargetMaterialTable(void);
void ReleaseDistractorMaterialTable(void);
void ReleaseTargetMaterialTable(void);
BOOL IsEscapeCondition(void);
BOOL IsDelKeyPressed(void);
void KillCRLF(char *txt);
void MakeDisplayAutistic(void);
void UndoAutism(void);
void WaitMSECS(DWORD msecs);
void WriteoutGatheredData(void);
void ExecuteNextDisplayStep(void);
void ShiftDSPlast10Nodes(void);
void AgingDSPlast10Nodes(void);
void cwCenter(HWND hWnd,int top);
BOOL DSPlast10NodesHasHiLightTarget(int *atIndex);
BOOL Ask4COM1Notifications(void);
int LoadMemImagesOfSounds(void);
long TellFileLength(char *name);
void MakeColorPalette(void);
BOOL InterpretationOfTCString(INTFORMTC *itc,char *tcString);
BOOL TerminatingPress(void);
void TSTRSenseKeys(BOOL init);
BOOL ManipulationAllowed(void);
void STCStartSimulatedTC(void);
BYTE Integer2BCD(DWORD integer);
void fillLowNibble(BYTE *bcd_targetbyte,char sourceNumber);
void fillHighNibble(BYTE *bcd_targetbyte,char sourceNumber);
void STCGeneratePseudoTC(DWORD timeNow,DWORD STCstartTime,TIMEONLY *fillMe);
BOOL RandomBinaryDecision(BOOL justInit);
BOOL OpenSerialCommunication(LPSTR comName);
void ShutDownSerialCommunication(void);
