// TASK2 - Windows NT Secondary Task program for driver workload studies 
// Compile with Visual C++ Version 6
//
// This is complicated, tricky code and it is ported from win16 the quick and dirty way.
// Much old code which could be recycled in future releases is also included.
// ==> Do not expect to understand anything immediately.
//
// This version runs on Windows NT. A new street segment has to be notified via a '#' on COM1.
// A keypress of the subject has to be notified iva a 't' on COM1. Transmission times are not
// critical, because it is not useful to measure reaction times in this task. In our experiments
// the notifications are generated by another computer, which has specialized hardware and 
// software for detecting experimental route segments and listening to a response key. The old 
// version of TSTRSenseKeys() (commented out) is an outline how to change this back to simple inport
// instructions (only feasible on win95/98, not on NT). Some knowledge about serial and parallel ports
// will be required, we assume that you are a programmer ;)

#include "stdafx.h"
#include "Task2.h"

#define PERMISSION_DENIED 0          // Allowed to change settings

// Globals
static char clutteredFillMaterial[] = "dist_clu.mat";
static char clutteredTestMaterial[] = "field_abl.mat";

static BOOL TSTRvp = FALSE;
static BOOL TSTRnextSituation = FALSE;
//static BOOL TSTRspoiledSituation = FALSE;

static OPENFILENAME ResultsOfn;
static char SzResultsSrcFilter[256]="Ablenkungsdatei (*.abl)\0*.abl\0Willkrlich (*.*)\0*.*\0ASCII-Extension (*.asc)\0*.asc\0Text-Extension (*.txt)\0*.txt\0";
static char SzResultsTitle[256]="Daten abspeichern unter";
static char SzResultsFile[256];
static char SzResultsFileTitle[256];

static HFONT HGloDspFont;                      // Font used to display material
static int DisplayWidth;                       // Subpane width
static int DisplayHeight;                      // Subpane height
static FILE *Results;                          // Results FILE structure

// Variables ending with WINI must be edited in your system's WIN.INI file (section [INCAR by WLP])
static GLOBALHANDLE HDistractorMaterialObject; // Handle to the memory object
static HP_TEXTDISPLAYNODE DistractorMaterial;  // Vector with distractors
static GLOBALHANDLE HTargetMaterialObject;     // Handle to the memory object
static HP_TEXTDISPLAYNODE TargetMaterial;      // Vector with targets
static GLOBALHANDLE HCollectedResultsObject;   // Handle to the memory object
static HP_RESULTSNODE CollectedResults;        // Vector for hits and false alarms
static GLOBALHANDLE HPromptSound;              // Handle to the memory object of prompt sound wavefile
static LPSTR LpszPromptSound;                  // LPSTR for in-memory image of prompt sound wavefile
static GLOBALHANDLE HHitSound;                 // Handle to the memory object of hit sound wavefile
static LPSTR LpszHitSound;                     // LPSTR for in-memory image of hit sound wavefile
static GLOBALHANDLE HFalseAlarmSound;          // Handle to the memory object of false-alarm sound wavefile
static HPALETTE HLogicalPalette;               // Color palette
static LPSTR LpszFalseAlarmSound;              // LPSTR for in-memory image of false-alarm sound wavefile 
static long NumDistractorStrings;              // # of slots in distractor vector
static long NumTargetStrings;                  // # of slots in targets vector
static HWND HWNDDispChild;                     // Handle to display window (a child window)
static RECT DSPClientRect;                     // Display window's coordinates
static int DSPHiAreaEntry;                     // Y-coordinate of begin of highlight area in display window
static int DSPHiAreaExit;                      // Y-coordinate of end of highlight area in display window
static int PrematureAlarmEntry;                // Y-coordinate of begin of 50% premature cue sirene
static TEXTDISPLAYNODE DSPlast10Nodes[10];     // The last ten strings dropped
static long IndexDistractorMaterialTable = 0;  // Slot index to HP_TEXTDISPLAYNODE with distractors
static long IndexTargetMaterialTable = 0;      // Slot index to HP_TEXTDISPLAYNODE with targets
static long IndexResultsTable = 0;             // Slot index to HP_RESULTSNODE
static DWORD MSECsInterScrollDelayWINI;        // Delay between two one-pixel scroll steps
static DWORD MSECsDemoRunLength;               // Length of a demo run in msec
static int HighLightOffBottomWINI;             // Pixel offset of highlight area from bottom
static int HighLightHeightWINI;                // highlight area height in % display window height
static TIMEONLY BCDVideoTime;                  // Anachronistic
static TIMEONLY BCDLastVideoTime;              // Anachronistic
static TIMEONLY BCDStartAt;                    // Anachronistic
static TIMEONLY BCDEndAt;                      // Anachronistic
static BOOL DistractorMaterialIsThere = FALSE; // Flag: distractor file choosen by experimenter
static BOOL TargetMaterialIsThere = FALSE;     // Flag: target file choosen by experimenter
static BOOL ResultFileNameIsThere = FALSE;     // Flag: name of results file choosen by experimenter 
static BOOL TrialEndDetected = FALSE;          // Anachronistic
static BOOL InAutisticState = FALSE;           // Working and ignoring messages
static BOOL ThisIsADemoRun = FALSE;            // Demonstration run
static BOOL ThisIsACalibrationRun = FALSE;     // Calibration run 
static BOOL DemoRunJustBegun = FALSE;          // Must be set to TRUE before triggering a demonstration run
static BOOL ExperimentalRunJustBegun = TRUE;   // Is set to false in 1st ExecuteNextDisplayStep() call
static BOOL InputViaCOM1 = FALSE;              // Notifications come via COM1 in experimental run
static BOOL CalibrationFaster;                 // Make display run faster ?
unsigned long CalibrationRunScrollCounter;     // Counts scroll steps when calibrating
static int CXTabSpace = 80;                    // Tabulators width in mean character width
static int GloCountSegments = 0;               // Street segments counter
static DWORD STCstartTime;                     // Anachronistic
static char GloComName[6];                     // Name of serial port usedAnachronistic
static HANDLE GloSerialHandle;                 // Handle to an RS232 interface
static long GloNumExpectedSegments;            // Number of segments
static OVERLAPPED OsReader = {0};              // For asynchronous i/o
static BOOL FWaitingOnRead = FALSE;            // Serial communications flag
static char ComName[5];                        // Name of serial port (e.g. COM1)

int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{
  MSG        msg;                              // MSG structure to store messages
  int        nRc;                              // return value from Register Classes

  strcpy(szAppName,"FIELDCAR");
  strcpy(szDispWndName,"DISPWIN");
  TSTRSenseKeys(TRUE); // Initializing

  hInst = hInstance;

  if(!hPrevInstance)
  {
     // register window classes if first instance of application
     if ((nRc = nCwRegisterClasses()) == -1)
     {
       // registering one of the windows failed
       LoadString(hInst,IDS_ERR_REGISTER_CLASS,szString,sizeof(szString));
       MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
       return nRc;
     }

     if ((nRc = LoadMemImagesOfSounds()) == -1)
     {
       // Could not read one of the wave files
       LoadString(hInst,IDS_ERR_WAVELOAD,szString,sizeof(szString));
       MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
       return nRc;
     }
  }

  InputViaCOM1 = Ask4COM1Notifications();

  // Color palette is born
  MakeColorPalette();

  // create application's main window
  hWndMain = CreateWindow(
                     szAppName,                     // Window class name
                     "Sekundraufgabe",             // Window's title
                     WS_OVERLAPPEDWINDOW,           // Style
                     0,                             // X
                     0,                             // Y
                     GetSystemMetrics(SM_CXSCREEN), // CX
                     GetSystemMetrics(SM_CYSCREEN), // CY
                     NULL,                          // Parent window's handle
                     NULL,                          // Default to Class Menu
                     hInst,                         // Instance of window
                     NULL);                         // Create struct for WM_CREATE


  if(hWndMain == NULL)
  {
    LoadString(hInst,IDS_ERR_CREATE_WINDOW,szString,sizeof(szString));
    MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
    return IDS_ERR_CREATE_WINDOW;
  }

  // Overdimensoned results table (NUMBEROFRESULTSLOTS == 1000)
  if ((HCollectedResultsObject=GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,NUMBEROFRESULTSLOTS*sizeof(RESULTSNODE))) == NULL)
  { 
    MessageBox(NULL,"Cannot allocate answer table","Fatal error",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }
  else if ((CollectedResults=(HP_RESULTSNODE)GlobalLock(HCollectedResultsObject)) == NULL)
  {
    MessageBox(NULL,"GlobalLock for answer table failed","Fatal error",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  memset(CollectedResults,0x00,sizeof(CollectedResults));

  GetINCAR6ProfileData();

  ShowWindow(hWndMain,SW_SHOWNORMAL);    // Display main window

  hAccel = LoadAccelerators(hInst,szAppName);

  HGloDspFont = CreateFont(-30,0,0,0,400,0,0,0,0,3,2,1,34,"Arial");

  // Message dispatcher with pseudo background task (method outdated, a win 3.x trick)
  do
  {
     if (TrialEndDetected) // End of experimental trial
     {
        TrialEndDetected = FALSE;

        if (InAutisticState) // While experiment running
          goto TREND; // Terminate message loop 'from inside'
     }

     while (PeekMessage(&msg,0,0,0,PM_REMOVE))
     {
        if (InAutisticState) // Only ExecuteNextDisplayStep() working
        {
          if (IsEscapeCondition()) // Experimenter hit <ESC> key
          {
TREND:      SendMessage(hWndMain,UD_UNDOAUTISM,0,0L);
          }
        }
        else // Listen to messages
        {
          if (msg.message == WM_QUIT)
             goto QUITAPPL;

          if (TranslateAccelerator(hWndMain,hAccel,&msg))
             continue;

          TranslateMessage(&msg);
          DispatchMessage(&msg);
        }
     }

     ExecuteNextDisplayStep(); // (nowadays) braindead implementation of a worker 'thread'

  } while (TRUE);

QUITAPPL:

  WriteINCAR6ProfileData(); // To WIN.INI

  // Do clean up before exiting from the application
  CwUnRegisterClasses();
  return msg.wParam;
}

// Main Window Procedure
LRESULT CALLBACK WndProc(HWND hWnd, WORD Message, WORD wParam, LONG lParam)
{
  HMENU      hMenu=0;    // Handle for the menu
  HBITMAP    hBitmap=0;  // Handle for bitmaps
  HDC        hDC;        // Handle for the display device
  PAINTSTRUCT ps;        // Holds PAINT information
  int        nRc=0;      // return code
  static char msg[512];  // Buffer for information message strings

  switch (Message)
  {
   case WM_COMMAND:
        switch (wParam)
        {
          case IDM_T_TIMERRESOLUTION:
               {
                 TIMECAPS timecaps;

                 timeGetDevCaps(&timecaps,sizeof(TIMECAPS));
                 wsprintf(msg,"Timing capabilitie sof your system: \
Minimal interval in msec is %u. Precision is \
+- %u msec.",
                 timecaps.wPeriodMin,
                 timecaps.wPeriodMin);
                 MessageBox(hWnd,msg,"Windows: \"minimum period supported by timer\"",MB_OK|MB_ICONINFORMATION);
               }
               break;

          case IDM_T_DISPMETRICS:
               {
                 HDC hdcInfo=CreateIC("DISPLAY",NULL,NULL,NULL);
                 RECT clientArea;
                 int width;
                 int height;

                 GetClientRect(HWNDDispChild,&clientArea); // Client area in pixels
                 DeleteDC(hdcInfo);
                 width=clientArea.right-clientArea.left;
                 height=clientArea.bottom-clientArea.top;

                 wsprintf(msg,"Display width is %d pixels, display height is %d pixels",width,height);

                 MessageBox(hWnd,msg,"Display area dimension",MB_OK|MB_ICONINFORMATION);
               }
               break;

          case IDM_T_ISD:
               {
                 wsprintf(msg,"InterScrollDelay = %lu msec. This parameter determines speed \
of scrolling text. Caveat: Actual speed is a result of an interaction \
of InterScrollDelay and your machine's performance. Measure it manually !",MSECsInterScrollDelayWINI);

                 MessageBox(hWnd,msg,"Scroll delay",MB_OK|MB_ICONINFORMATION);
               }
               break;

          case IDM_T_HERVOREINTRITT:
               {
                 wsprintf(msg,"Percent window height -- seen from window's bottom -- where highlight area begins = %d. \
To be changed with STANDARD_HIGHLIGHTOFFBOTTOM=Value in section [INCAR by WLP] of win.ini.",HighLightOffBottomWINI);

                 MessageBox(hWnd,msg,"Begin of highlight area",MB_OK|MB_ICONINFORMATION);
               }
               break;

          case IDM_T_HERVORHOEHE:
               {
                 wsprintf(msg,"Percent height of highlight area -- in percent window height = %d. \
To be changed with STANDARD_HIGHLIGHTHEIGHT=Value in section [INCAR by WLP] of win.ini.",HighLightHeightWINI);

                 MessageBox(hWnd,msg,"Height of highlight area",MB_OK|MB_ICONINFORMATION);
               }
               break;

          case IDM_T_BEENDEN:
               PostMessage(hWnd,WM_CLOSE,0,0L);
               break;

          case IDM_E_DISPLAYHOEHER:
               if (ManipulationAllowed())
                 SizeWindow(HWNDDispChild,HOEHER);
               break;

          case IDM_E_DISPLAYBREITER:
               if (ManipulationAllowed())
                 SizeWindow(HWNDDispChild,BREITER);
               break;

          case IDM_E_DISPLAYNIEDRIGER:
               if (ManipulationAllowed())
                 SizeWindow(HWNDDispChild,NIEDRIGER);
               break;

          case IDM_E_DISPLAYSCHMAELER:
               if (ManipulationAllowed())
                 SizeWindow(HWNDDispChild,SCHMAELER);
               break;

          case IDM_E_FONTSELECTION:
               // In this version, HGloDspFont is created once in WinMain
               InvalidateRect(HWNDDispChild,NULL,TRUE);    // Force WM_PAINT message
               PostMessage(HWNDDispChild,WM_SIZE,0,0L);    
               break;

          case IDM_E_DISTRACTORMATERIAL:
               if (DistractorMaterialIsThere)
               {
                 ReleaseDistractorMaterialTable();
                 DistractorMaterialIsThere = FALSE;
               }

               MakeDistractorMaterialTable();

               if (DistractorMaterialIsThere && TargetMaterialIsThere && ResultFileNameIsThere)
               {
                 EnableMenuItem(GetMenu(hWndMain),IDM_E_CALIBRATESPEEDDOWN,MF_BYCOMMAND|MF_ENABLED);
                 EnableMenuItem(GetMenu(hWndMain),IDM_E_CALIBRATESPEEDUP,MF_BYCOMMAND|MF_ENABLED);
               }
               break;

          case IDM_E_TARGETMATERIAL:
               if (TargetMaterialIsThere)
               {
                 ReleaseTargetMaterialTable();
                 TargetMaterialIsThere = FALSE;
               }

               MakeTargetMaterialTable();

               if (DistractorMaterialIsThere && TargetMaterialIsThere && ResultFileNameIsThere)
               {
                 EnableMenuItem(GetMenu(hWndMain),IDM_E_CALIBRATESPEEDDOWN,MF_BYCOMMAND|MF_ENABLED);
                 EnableMenuItem(GetMenu(hWndMain),IDM_E_CALIBRATESPEEDUP,MF_BYCOMMAND|MF_ENABLED);
               }
               break;

          case IDM_E_RESULTSFILENAME:
               if (GetSaveFileName(&ResultsOfn))
               {
                 if ((Results=fopen(SzResultsFile,"w")) == NULL)
                 {
                   MessageBox(NULL,"Starten Sie Windows neu","Kann Ergebnisdatei nicht ffnen",MB_OK|MB_ICONHAND);
                   SendMessage(hWndMain,WM_CLOSE,0,0L);
                 }
                 else
                 {
                   ResultFileNameIsThere = TRUE;
                 }

                 // Results is closed later by WriteoutGatheredData()
                 if (DistractorMaterialIsThere && TargetMaterialIsThere && ResultFileNameIsThere)
                 {
                   EnableMenuItem(GetMenu(hWndMain),IDM_E_CALIBRATESPEEDDOWN,MF_BYCOMMAND|MF_ENABLED);
                   EnableMenuItem(GetMenu(hWndMain),IDM_E_CALIBRATESPEEDUP,MF_BYCOMMAND|MF_ENABLED);
                 }
               }
               break;

          case IDM_INTRO: // Demonstration of the sounds for the subject
               sndPlaySound("Intro0.wav",SND_SYNC);
               sndPlaySound("Intro1.wav",SND_SYNC);
               sndPlaySound("Intro2.wav",SND_SYNC);
               sndPlaySound("Icprompt.wav",SND_SYNC);
               sndPlaySound("Intro3.wav",SND_SYNC);
               sndPlaySound("Intro4.wav",SND_SYNC);
               sndPlaySound("Intro5.wav",SND_SYNC);
               sndPlaySound("Ichit.wav",SND_SYNC);
               sndPlaySound("Intro6.wav",SND_SYNC);
               sndPlaySound("Icfalse.wav",SND_SYNC);
               sndPlaySound("Intro7.wav",SND_SYNC);
               break;

          case IDM_E_CALIBRATESPEEDUP:    
               if (ManipulationAllowed())
               {
                 CalibrationFaster = TRUE;
                 MSECsDemoRunLength = 5000;
                 CalibrationRunScrollCounter = 0;

                 MessageBox(NULL,"Caveat: There are always interactions between display size and speed.","Display speedup",MB_ICONINFORMATION|MB_OK);
                 ThisIsACalibrationRun = TRUE;
                 DemoRunJustBegun = TRUE; // So ExecuteNextDislpayStep() knows start time
                 PostMessage(hWndMain,WM_COMMAND,IDM_E_HANDSTART,0L);
               }
               break;

          case IDM_E_CALIBRATESPEEDDOWN:
               if (ManipulationAllowed())
               {
                 CalibrationFaster = FALSE; 
                 MSECsDemoRunLength = 5000;
                 CalibrationRunScrollCounter = 0;

                 MessageBox(NULL,"Caveat: There are always interactions between display size and speed.","Display slowdown",MB_ICONINFORMATION|MB_OK);
                 ThisIsACalibrationRun = TRUE;
                 DemoRunJustBegun = TRUE; // So ExecuteNextDislpayStep() knows start time
                 PostMessage(hWndMain,WM_COMMAND,IDM_E_HANDSTART,0L);
               }
               break;

          case IDM_INTERN_CALIBRATIONSTEP:
               {
                 char msg[256];
                 char head[128];
                 unsigned long scrollsPerSecond = CalibrationRunScrollCounter/5; // Each step lasts 5 seconds
                 CalibrationRunScrollCounter = 0;

                 wsprintf(head,"InterScrollDelay is %lu msec",MSECsInterScrollDelayWINI);

                 if (CalibrationFaster)
                 {
                   wsprintf(msg,"Scroll speed is %lu pixels per second. Do you want to make it faster ?",scrollsPerSecond);

                 }
                 else
                 {
                   wsprintf(msg,"Scroll speed is %lu pixels per second. Do you want to make it slower ?",scrollsPerSecond);
                 }

                 if (IDYES == MessageBox(NULL,msg,head,MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2))
                 {
                   // Change InterScrollDelay
                   if (CalibrationFaster == TRUE && MSECsInterScrollDelayWINI > 0)
                   {
                     MSECsInterScrollDelayWINI -= 1;
                   }
                   else
                   {
                     MSECsInterScrollDelayWINI += 1;
                   }

                   // Restart 5-seconds demo run
                   ThisIsACalibrationRun = TRUE;
                   DemoRunJustBegun = TRUE; // So ExecuteNextDislpayStep() knows start time
                   PostMessage(hWndMain,WM_COMMAND,IDM_E_HANDSTART,0L);
                 }
                 else
                 {
                   ThisIsACalibrationRun = FALSE;
                   WriteINCAR6ProfileData();
                 }
               }
               break;

          case IDM_E_HANDSTART:
               if (TRUE)
               {
                 memset(DSPlast10Nodes,0x00,sizeof(DSPlast10Nodes));
                 MakeDisplayAutistic();
               }
               else
               {
                 MessageBeep(MB_ICONHAND);
                 MessageBox(hWnd,"Setup incomplete","Start impossible",MB_ICONHAND|MB_OK);
               }
               break;

          default:
               return DefWindowProc(hWnd, Message, wParam, lParam);
        }
        break;

   case WM_CREATE:
        {
          RECT client;

          GetClientRect(hWnd,&client);

          HWNDDispChild = CreateWindow(szDispWndName,
                                     NULL,
                                     WS_CHILDWINDOW |
                                     WS_VISIBLE|
                                     WS_CLIPSIBLINGS,
                                     client.right/3,  // Will be overriden by data from profile
                                     client.bottom/3, // Will be overriden by data from profile
                                     400,             // Will be overriden by data from profile
                                     288,             // Will be overriden by data from profile
                                     hWnd,
                                     (HMENU)1,
                                     (HINSTANCE)hInst,
                                     NULL);

          ShowWindow(HWNDDispChild,SW_SHOWNORMAL);

          // Initializations for commom dialogs
          // Changing results file
          ResultsOfn.lStructSize = sizeof(OPENFILENAME);
          ResultsOfn.hwndOwner = hWnd;
          ResultsOfn.lpstrFilter = SzResultsSrcFilter;
          ResultsOfn.lpstrCustomFilter = NULL;
          // DWORD     nMaxCustFilter; ignored
          ResultsOfn.nFilterIndex = 1;
          ResultsOfn.lpstrFile = SzResultsFile;
          ResultsOfn.nMaxFile = 256;
          ResultsOfn.lpstrFileTitle = SzResultsTitle;
          ResultsOfn.nMaxFileTitle = sizeof(SzResultsTitle);
          ResultsOfn.lpstrInitialDir = NULL;
          ResultsOfn.lpstrTitle = SzResultsTitle;
          ResultsOfn.Flags = OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY;
          // UINT nFileOffset; filled on input
          // UINT nFileExtension; filled on input
          ResultsOfn.lpstrDefExt = "*";
          ResultsOfn.lCustData = (DWORD)NULL;
          ResultsOfn.lpfnHook = NULL;
          ResultsOfn.lpTemplateName = NULL;

          DistractorMaterial = NULL;

          PostMessage(hWnd,WM_COMMAND,IDM_E_DISTRACTORMATERIAL,0L);
          PostMessage(hWnd,WM_COMMAND,IDM_E_TARGETMATERIAL,0L);

          InvalidateRect(HWNDDispChild,NULL,TRUE);    // Force WM_PAINT message
          PostMessage(hWnd,WM_COMMAND,IDM_E_RESULTSFILENAME,0L);
        }
        break;

   case WM_MOVE:
        break;

   case WM_SIZE:
        MoveWindow(HWNDDispChild,0,0,DisplayWidth,DisplayHeight,FALSE);
        // Center display area
        cwCenterChild(HWNDDispChild,0);
        break;       

   case WM_PAINT:
        memset(&ps, 0x00, sizeof(PAINTSTRUCT));
        hDC = BeginPaint(hWnd, &ps);
        SetBkMode(hDC, TRANSPARENT);
        EndPaint(hWnd, &ps);
        break;

   case WM_CLOSE:
        DeleteObject(HGloDspFont);
        GlobalUnlock(HCollectedResultsObject);
        GlobalFree(HCollectedResultsObject);
        DestroyWindow(HWNDDispChild);
        DestroyWindow(hWndMain);
        PostQuitMessage(0);
        break;

   case UD_WRITEOUTDATA:
        WriteoutGatheredData();
        break;

   case UD_UNDOAUTISM:
        {
          InAutisticState = FALSE;
          ShowCursor(TRUE);
          IndexDistractorMaterialTable = 0;  // Re-init for next run
          IndexTargetMaterialTable = 0;      // Re-init for next run
          IndexResultsTable = 0;             // Re-init for next run
          ShutDownSerialCommunication();
          ShowWindow(hWndMain,SW_SHOWNA);    // Main window has to repaint itself

          if (ThisIsACalibrationRun)
          {
            PostMessage(hWndMain,WM_COMMAND,IDM_INTERN_CALIBRATIONSTEP,0L);
          }
          else
          {
            PostMessage(hWndMain,UD_WRITEOUTDATA,0,0L);
          }
        }
        break;

   default:
        return DefWindowProc(hWnd,Message,wParam,lParam);
  }
  return 0L;
}

int nCwRegisterClasses(void)
{
  WNDCLASS wndclass;
  memset(&wndclass, 0x00, sizeof(WNDCLASS));

  wndclass.style = CS_HREDRAW|CS_VREDRAW|CS_OWNDC;
  wndclass.lpfnWndProc = (WNDPROC)WndProc;
  wndclass.cbClsExtra = 0;
  wndclass.cbWndExtra = 0;
  wndclass.hInstance = hInst;
  wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
  wndclass.hbrBackground = CreateSolidBrush(RGB(0,0,0));
  wndclass.lpszMenuName = szAppName;   // Menu Name is App Name
  wndclass.lpszClassName = szAppName;  // Class Name is App Name

  if(!RegisterClass(&wndclass))
    return -1;

  wndclass.style=CS_HREDRAW|CS_VREDRAW|CS_OWNDC;
  wndclass.lpfnWndProc=(WNDPROC)DispWndProc;
  wndclass.hIcon=NULL;
  wndclass.lpszClassName=szDispWndName;
  wndclass.hbrBackground=CreateSolidBrush(RGB(0,0,0));

  if(!RegisterClass(&wndclass))
    return -1;

  return(0);
}

void CwUnRegisterClasses(void)
{
  WNDCLASS   wndclass;
  memset(&wndclass,0x00,sizeof(WNDCLASS));

  GetClassInfo(hInst,szAppName,&wndclass);
  DeleteObject(wndclass.hbrBackground);
  UnregisterClass(szAppName,hInst);

  GetClassInfo(hInst,szDispWndName,&wndclass);
  DeleteObject(wndclass.hbrBackground);
  UnregisterClass(szDispWndName,hInst);
}

LRESULT CALLBACK DispWndProc(HWND hWnd,WORD Message,WORD wParam,LONG lParam)
{
  HDC hdc;
  PAINTSTRUCT ps;

  switch (Message)
  {
    case WM_CREATE:
         break;

    case WM_SIZE:
         GetClientRect(hWnd,&DSPClientRect);
         // Lower boundary of highlight area
         DSPHiAreaEntry = (int)(((double)DSPClientRect.bottom * (double)HighLightOffBottomWINI) / 100.);
         // Upper boundary of highlight area
         DSPHiAreaExit = DSPHiAreaEntry+(int)(((double)DSPClientRect.bottom * (double)HighLightHeightWINI) / 100.);
				 // When half of the highlight area is reached, a premature cue occurs (if it does occur)
				 PrematureAlarmEntry = DSPHiAreaEntry - ((DSPHiAreaExit - DSPHiAreaEntry) / 2);
         break;

    case WM_PAINT: // Validate client area
         memset(&ps,0x00,sizeof(PAINTSTRUCT));
         hdc = BeginPaint(hWnd,&ps);
         EndPaint(hWnd,&ps);
         break;

    case WM_CLOSE:
         DestroyWindow(hWnd);
         break;

    case WM_DESTROY:
         break;

   default: return DefWindowProc(hWnd,Message,wParam,lParam);
  }
  return 0L;
}

void cwCenterChild(HWND hWnd,int top)
{
  POINT pt;
  RECT  swp;
  RECT  rParent;
  int   iwidth;
  int   iheight;

  GetWindowRect(hWnd, &swp);
  GetClientRect(hWndMain, &rParent);

  iwidth = swp.right - swp.left;
  iheight = swp.bottom - swp.top;

  pt.x = (rParent.right - rParent.left) / 2;
  pt.y = (rParent.bottom - rParent.top) / 2;
  // ClientToScreen(hWndMain, &pt); only if you move relative to parent
  // (not with child windows)

  pt.x = pt.x - (iwidth / 2);
  pt.y = pt.y - (iheight / 2);

  if(top)
    pt.y = pt.y + top;

  MoveWindow(hWnd,pt.x,pt.y,iwidth,iheight,FALSE);
}

void SizeWindow(HWND hWnd,RESIZETYPE resize)
{
  POINT pt;
  RECT swp;
  RECT rParent;
  int iwidth;
  int iheight;

 GetWindowRect(hWnd,&swp);
 GetClientRect(hWndMain,&rParent);

 switch (resize)
 {
   case HOEHER:
        swp.bottom++;
        break;

   case BREITER:
        swp.right++;
        break;

   case NIEDRIGER:
        swp.bottom--;
        break;

   case SCHMAELER:
        swp.right--;
        break;
 }

 DisplayWidth = iwidth = swp.right - swp.left;
 DisplayHeight = iheight = swp.bottom - swp.top;
 pt.x = (rParent.right - rParent.left) / 2;
 pt.y = (rParent.bottom - rParent.top) / 2;
 pt.x = pt.x - (iwidth / 2);
 pt.y = pt.y - (iheight / 2);

 MoveWindow(hWnd,pt.x,pt.y,iwidth,iheight,TRUE);
}

void GetINCAR6ProfileData(void)
{
  static char retString[128];
  char myName[] = "INCAR by WLP";
  char szSt[] = {'0','0','\0'};
  char szMi[] = {'0','0','\0'};
  char szSe[] = {'0','0','\0'};
  char szFr[] = {'0','0','\0'};

  // Standard settings are for an Acer TravelMate 525 TXV notebook set to
  // VGA resolution and with monitor output plugged to the VGA-Display
  GetProfileString(myName,"STANDARD_ISD","9",retString,sizeof(retString));
  MSECsInterScrollDelayWINI = (DWORD)atoi(retString);

  GetProfileString(myName,"STANDARD_HIGHLIGHTOFFBOTTOM","40",retString,sizeof(retString));
  HighLightOffBottomWINI = atoi(retString);

  GetProfileString(myName,"STANDARD_HIGHLIGHTHEIGHT","60",retString,sizeof(retString));
  HighLightHeightWINI = atoi(retString);

  GetProfileString(myName,"DISPLAYWIDTH","600",retString,sizeof(retString));
  DisplayWidth = atoi(retString);

  GetProfileString(myName,"DISPLAYHEIGHT","150",retString,sizeof(retString));
  DisplayHeight = atoi(retString);
}

void WriteINCAR6ProfileData(void)
{
  static char setString[128];
  char myName[] = "INCAR by WLP";

  wsprintf(setString,"%lu",MSECsInterScrollDelayWINI);
  WriteProfileString(myName,"STANDARD_ISD",setString);

  wsprintf(setString,"%d",HighLightOffBottomWINI);
  WriteProfileString(myName,"STANDARD_HIGHLIGHTOFFBOTTOM",setString);

  wsprintf(setString,"%d",HighLightHeightWINI);
  WriteProfileString(myName,"STANDARD_HIGHLIGHTHEIGHT",setString);

  wsprintf(setString,"%d",DisplayWidth);
  WriteProfileString(myName,"DISPLAYWIDTH",setString);

  wsprintf(setString,"%d",DisplayHeight);
  WriteProfileString(myName,"DISPLAYHEIGHT",setString);
}

void MakeDistractorMaterialTable(void)
{
  FILE *src;
  long nLines=0;
  char commands[128];
  char restLine[128];
  char wholeLine[256];
  TEXTDISPLAYNODE insert;
  long run;

  // Count strings
  if ((src=fopen(clutteredFillMaterial,"r")) == NULL)
  {
    MessageBox(NULL,"Kann Displaymaterialdatei nicht ffnen","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  while (NULL != fgets(wholeLine,sizeof(wholeLine),src))
    nLines++;

  fclose(src);

  // Allocate table based on count information
  if ((HDistractorMaterialObject=GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,nLines*sizeof(TEXTDISPLAYNODE))) == NULL)
  {
    MessageBox(NULL,"Kann Speicherobjekt fr Distraktormaterialtabelle nicht allozieren","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }
  else if ((DistractorMaterial=(HP_TEXTDISPLAYNODE)GlobalLock(HDistractorMaterialObject)) == NULL)
  {
    MessageBox(NULL,"GlobalLock fr Distraktormaterialtabelle fehlgeschlagen","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  // Read in material
  if ((src=fopen(clutteredFillMaterial,"r")) == NULL)
  {
    MessageBox(NULL,"Kann Distraktormaterialdatei nicht wiedererffnen","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  RandomBinaryDecision(TRUE); // Just initialize random number generator
	
	for(run=0;run < nLines;run++)
  {
    memset(&insert,0x00,sizeof(TEXTDISPLAYNODE));

    // Fetch commands
    fscanf(src,"%s",commands);

    if (strstr(commands,"DROPTEXT") != NULL) // Since timed alarm only is possible!
    {
      insert.flags |= DROPTEXT;
    }

    if (strstr(commands,"LOUDTARGETHIGHLIGHT") != NULL)
    {
      if (RandomBinaryDecision(FALSE))
			{
				insert.flags |= TRUELOUDTARGETHIGHLIGHT;
			}
			else
			{
				insert.flags |= PREMATUREWARNEDTARGETHIGHLIGHT;
			}
    }

    if (strstr(commands,"SILENTTARGETHIGHLIGHT") != NULL)
    {
      insert.flags |= SILENTTARGETHIGHLIGHT;
    }

    if (strstr(commands,"LOUDDISTRACTHIGHLIGHT") != NULL)
    {
			insert.flags |= LOUDDISTRACTHIGHLIGHT;
    }

    if (strstr(commands,"SILENTDISTRACTHIGHLIGHT") != NULL)
    {
      insert.flags |= SILENTDISTRACTHIGHLIGHT;
    }

    // Fetch dropstring 
    fgets(restLine,sizeof(restLine),src);
    KillCRLF(restLine);

    lstrcpy(insert.text,restLine); 
    memcpy(DistractorMaterial+run,(HP_TEXTDISPLAYNODE)&insert,sizeof(TEXTDISPLAYNODE));
  }

  fclose(src);
  NumDistractorStrings=nLines;
  DistractorMaterialIsThere=TRUE;
}

void MakeTargetMaterialTable(void)
{
  FILE *src;
  long nLines=0;
  char showTimes[64];
  char commands[128];
  char restLine[128];
  char wholeLine[320];
  TEXTDISPLAYNODE insert;
  long run;

  // Count strings 
  if ((src=fopen(clutteredTestMaterial,"r")) == NULL)
  {
    MessageBox(NULL,"Kann Zielreizmaterialdatei nicht ffnen","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  while (NULL != fgets(wholeLine,sizeof(wholeLine),src))
    nLines++;

  fclose(src);

  GloNumExpectedSegments = nLines;

  // Allocate table based on count information
  if ((HTargetMaterialObject=GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,nLines*sizeof(TEXTDISPLAYNODE))) == NULL)
  {
    MessageBox(NULL,"Kann Speicherobjekt fr Zielreizmaterialtabelle nicht allozieren","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }
  else if ((TargetMaterial=(HP_TEXTDISPLAYNODE)GlobalLock(HTargetMaterialObject)) == NULL)
  {
    MessageBox(NULL,"GlobalLock fr Zielreizmaterialtabelle fehlgeschlagen","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  // Read in material
  if ((src=fopen(clutteredTestMaterial,"r")) == NULL)
  {
    MessageBox(NULL,"Kann Zielreizmaterialdatei nicht wiedererffnen","Fataler Fehler",MB_OK|MB_ICONHAND);
    SendMessage(hWndMain,WM_CLOSE,0,0L);
  }

  RandomBinaryDecision(TRUE); // Just initialize random number generator

  for(run=0;run < nLines;run++)
  {
    memset(&insert,0x00,sizeof(TEXTDISPLAYNODE));

    // Fetch presentation times
    fscanf(src,"%s",showTimes);

    if (!InterpretationOfTCString(&(insert.dropTime),showTimes))
    {
      char msg[128];

      sprintf(msg,"Zielreizdatei Zeile %u: Fehler im Timecode",run+1);
      MessageBox(NULL,msg,"Fataler Fehler",MB_OK|MB_ICONHAND);
      SendMessage(hWndMain,WM_CLOSE,0,0L);
    }

    // Fetch commands
    fscanf(src,"%s",commands);

    if (strstr(commands,"DROPTEXT") != NULL) // For timed alarm only is possible!
    {
      insert.flags |= DROPTEXT;
    }

    if (strstr(commands,"LOUDTARGETHIGHLIGHT") != NULL)
    {
      if (RandomBinaryDecision(FALSE))
			{
				insert.flags |= TRUELOUDTARGETHIGHLIGHT;
			}
			else
			{
				insert.flags |= PREMATUREWARNEDTARGETHIGHLIGHT;
			}
    }

    if (strstr(commands,"SILENTTARGETHIGHLIGHT") != NULL)
    {
      insert.flags |= SILENTTARGETHIGHLIGHT;
    }

    if (strstr(commands,"LOUDDISTRACTHIGHLIGHT") != NULL)
    {
			insert.flags |= LOUDDISTRACTHIGHLIGHT;
    }

    if (strstr(commands,"SILENTDISTRACTHIGHLIGHT") != NULL)
    {
      insert.flags |= SILENTDISTRACTHIGHLIGHT;
    }

    // Fetch dropstring
    fgets(restLine,sizeof(restLine),src);
    KillCRLF(restLine);

    lstrcpy(insert.text,restLine); 
    memcpy(TargetMaterial+run,(HP_TEXTDISPLAYNODE)&insert,sizeof(TEXTDISPLAYNODE));
  }

  fclose(src);
  NumTargetStrings=nLines;
  TargetMaterialIsThere=TRUE;
}


void ReleaseDistractorMaterialTable(void)
{
  GlobalUnlock(HDistractorMaterialObject);
  GlobalFree(HDistractorMaterialObject);
  DistractorMaterialIsThere=FALSE;
}

void ReleaseTargetMaterialTable(void)
{
  GlobalUnlock(HTargetMaterialObject);
  GlobalFree(HTargetMaterialObject);
  TargetMaterialIsThere=FALSE;
}

BOOL IsEscapeCondition(void)
{
  if (GetAsyncKeyState(VK_ESCAPE))
  {
    if (GetAsyncKeyState(VK_ESCAPE))
    {
      return TRUE;
    }
  }

  return FALSE;
}

BOOL IsDelKeyPressed(void)
{
  if (GetAsyncKeyState(VK_DELETE))
  {
    if (GetAsyncKeyState(VK_DELETE))
    {
      return TRUE;
    }
  }

  return FALSE;
}


// Replace carriage return and line feed with \0
void KillCRLF(char *txt)
{
  char CRLF[3];
  char *target;

  CRLF[0] = 0x0d;
  CRLF[1] = 0x0a;
  CRLF[2] = 0x00;

  if ((target=strchr(txt,'\n')) != NULL)
    *target = '\0';
}

// Overpaints caption und menu line, which are ineffective
void MakeDisplayAutistic(void)
{
  HDC    hdc;
  HBRUSH hbr = CreateSolidBrush(RGB(0,0,0));
  HRGN   hrgn;

  hdc = GetWindowDC(hWndMain);

  hrgn = CreateRectRgn(0,0,5000,5000); // paint it black guarantee
  FillRgn(hdc,hrgn,hbr);

  ReleaseDC(hWndMain,hdc);
  DeleteObject(hrgn);
  DeleteObject(hbr);
  ShowCursor(FALSE);
	OpenSerialCommunication("COM1:"); 
	STCStartSimulatedTC();
  InAutisticState = TRUE;
}

void UndoAutism(void) // Obsolete
{
  InAutisticState = FALSE;         
  ShowCursor(TRUE);                
  IndexDistractorMaterialTable = 0;
  IndexTargetMaterialTable = 0;
  IndexResultsTable = 0;           
  SetWindowText(hWndMain,"Task2: sleeping");
  ShowWindow(hWndMain,SW_SHOWNA);  

  if (ThisIsACalibrationRun)
  {
    PostMessage(hWndMain,WM_COMMAND,IDM_INTERN_CALIBRATIONSTEP,0L);
  }
  else
  {
    PostMessage(hWndMain,UD_WRITEOUTDATA,0,0L);
  }
}

// Millisecond precision delay using MMSYSTEM.DLL
void WaitMSECS(DWORD msecs)
{
  DWORD run;
  DWORD multiplesOf10 = msecs / 10;
  DWORD restTime = msecs % 10;
  DWORD offStart;
  DWORD start;

  if (InputViaCOM1)
  {
  	TSTRSenseKeys(FALSE); 
  }
  else
  {
    if (IsDelKeyPressed())
    {
      TSTRvp = TRUE;
    }
  }

  // 10 msec time slices
  for(run=0;run < multiplesOf10;run++)
  {
    // Wait 10 msec
    start = timeGetTime();

    do
    {
      offStart = timeGetTime();
      offStart -= start;
    } while (offStart < 10);

    // Ask for signal at RS232
    if (InputViaCOM1)
    {
      TSTRSenseKeys(FALSE);
    }
    else
    {
      if (IsDelKeyPressed())
      {
        TSTRvp = TRUE;
      }
    }
  }

  // Wait rest of the time
  start = timeGetTime();

  do
  {
    offStart = timeGetTime();
    offStart -= start;
  } while (offStart < msecs);
}

// Worker task
// Be careful with changes in drawing logic !
void ExecuteNextDisplayStep(void)
{
  HDC hdc;                                    // An HDC for the display window
  HFONT hFntBackup;                           // Font backup handle
  static int countDown = AWAITNTIMERS;        // Counter for scroll steps done
  static RESULTSNODE localCopyResultsNode;    // Local copy of a node (becuse of _huge, anachronistic)
  static PAINTSTRUCT ps;                      // A PAINTSTRUCT
  static POINT hiArea;                        // Y-Coordinates of begin and end of highlight section
  int run;                                    // Iteration counter
  BOOL highLightedTarget;                     // A target cue is in highlight area
  int indexOfHLT;                             // Index of target cue is in answer area (array DSPlast10Nodes)
  static DWORD startTimeOfCurrentRun;         // The value delivered by timeGetTime() at trial start
  HPALETTE oldPalette;                        // Handle to old color palette

  if (InAutisticState)
  {
		if (!DistractorMaterialIsThere)
  	{
  		MessageBox(hWndMain,"Distractor material not ready",NULL,MB_OK|MB_ICONHAND);
  		return;
  	}

  	if (!TargetMaterialIsThere)
  	{
  		MessageBox(hWndMain,"Target material not ready",NULL,MB_OK|MB_ICONHAND);
  		return;
  	}

		if (!ResultFileNameIsThere)
  	{
  		MessageBox(hWndMain,"Result file name undefined",NULL,MB_OK|MB_ICONHAND);
  		return;
  	}

    // Get Time code (simulated in this version)
    if (!ThisIsADemoRun && !ThisIsACalibrationRun)
    {
			DWORD timeNow = timeGetTime();
			STCGeneratePseudoTC(timeNow,STCstartTime,&BCDVideoTime); 

			if (ExperimentalRunJustBegun)
      {
        startTimeOfCurrentRun=timeGetTime();
        ExperimentalRunJustBegun=FALSE;
      }
    }
    else
    {
      BCDVideoTime.bcdSt = 0x99; // Nonsense-Value: no timecode!
      BCDVideoTime.bcdMi = 0x99; // Nonsense-Value: no timecode!
      BCDVideoTime.bcdSe = 0x99; // Nonsense-Value: no timecode!
      BCDVideoTime.bcdFr = 0x99; // Nonsense-Value: no timecode!

      if (DemoRunJustBegun) // First ExecuteNextDisplay-call in a demo run
      {
        startTimeOfCurrentRun=timeGetTime();
        DemoRunJustBegun=FALSE;
      }
    }

    // Change dropstring, when drop area is maximally hidden below lower display area boundary
    if (countDown == AWAITNTIMERS) // (this is first use of AWAITNTIMERS)
    {
			// If the node being discarded now is a MISS
      if (((DSPlast10Nodes[9].flags & TRUELOUDTARGETHIGHLIGHT) || (DSPlast10Nodes[9].flags & PREMATUREWARNEDTARGETHIGHLIGHT) || (DSPlast10Nodes[9].flags & SILENTTARGETHIGHLIGHT)) && !(DSPlast10Nodes[9].flags & BEENDEADCOLORED))
      {
        // Write MISS to results table
        localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
        localCopyResultsNode.videoTC = BCDVideoTime;
        lstrcpy(localCopyResultsNode.text,DSPlast10Nodes[9].text);
        lstrcpy(localCopyResultsNode.reactionType,"MISS");
        memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
        IndexResultsTable++;
      }

      ShiftDSPlast10Nodes(); // Every entry ages one position, the last is forgotten

      // Get next display line (target or distractor)
      if (TSTRnextSituation && GloCountSegments <= GloNumExpectedSegments)
      {
        TSTRnextSituation = FALSE;

        memcpy((HP_TEXTDISPLAYNODE)&DSPlast10Nodes[0],TargetMaterial+IndexTargetMaterialTable,sizeof(TEXTDISPLAYNODE));
        DSPlast10Nodes[0].age = AUSGLEICH - AWAITNTIMERS; // Set birth date

        if (IndexTargetMaterialTable < NumTargetStrings-1) // End of list not reached
        {
          IndexTargetMaterialTable++;
        }
      }
      else
      {
        memcpy((HP_TEXTDISPLAYNODE)&DSPlast10Nodes[0],DistractorMaterial+IndexDistractorMaterialTable,sizeof(TEXTDISPLAYNODE));
        DSPlast10Nodes[0].age = AUSGLEICH - AWAITNTIMERS; // Set birth date
        IndexDistractorMaterialTable++;
      }

      // Cycle through distractor material
      if (IndexDistractorMaterialTable == NumDistractorStrings-1)
      {
        IndexDistractorMaterialTable=0;
      }
    }

    ScrollWindow(HWNDDispChild,0,-1,NULL,NULL);
    CalibrationRunScrollCounter++;

    countDown--;
    AgingDSPlast10Nodes(); // Update age counter

    hdc=BeginPaint(HWNDDispChild,&ps);
    hFntBackup=(HFONT)SelectObject(hdc,HGloDspFont);
    SetBkMode(hdc,OPAQUE);
    SetTextAlign(hdc,TA_LEFT|TA_BOTTOM);

    // Care for new string
    oldPalette=SelectPalette(hdc,HLogicalPalette,FALSE);
    RealizePalette(hdc);
    SetTextColor(hdc,PALETTEINDEX(CALGRAY_PINDEX)); // Normal color
    SetBkColor(hdc,RGB(0,0,0)); // Black background
    TabbedTextOut(hdc,
                  DSPClientRect.left,
                  DSPClientRect.bottom+(countDown-5),
                  DSPlast10Nodes[0].text,
                  strlen(DSPlast10Nodes[0].text),
                  1,
                  &CXTabSpace,
                  0);

    SelectPalette(hdc,oldPalette,FALSE);
    EndPaint(HWNDDispChild,&ps);
    // This 'opens' the clipping rectangle...
    InvalidateRect(HWNDDispChild,NULL,FALSE);
    // ...we need this BeginPaint-EndPaint
    hdc=BeginPaint(HWNDDispChild,&ps);

    oldPalette=SelectPalette(hdc,HLogicalPalette,FALSE);
    RealizePalette(hdc);
    SetTextColor(hdc,PALETTEINDEX(PUREGREEN_PINDEX)); // Standard green
    SetBkColor(hdc,RGB(0,0,0)); // Black background

    for(run=0;run<10;run++) // Lookup the in the 'memory' 
    {
      // Premature cue
			if (strlen(DSPlast10Nodes[run].text) &&
          !(DSPlast10Nodes[run].flags & BEENPREMATURESIRENED) &&  // Only once
          DSPlast10Nodes[run].age >= PrematureAlarmEntry)         // Premature alarm now
      {
        // SNDPROMPT-requests & protocol
        if (DSPlast10Nodes[run].flags & PREMATUREWARNEDTARGETHIGHLIGHT) 
        {
					DSPlast10Nodes[run].flags |= BEENPREMATURESIRENED;
					
					if (!ThisIsACalibrationRun)
          {
            sndPlaySound(LpszPromptSound,SND_ASYNC|SND_MEMORY); // Sound-prompt
          }

          localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
          localCopyResultsNode.videoTC = BCDVideoTime;
          lstrcpy(localCopyResultsNode.text,"DROPPED PREMATURE TARGET SIREN");
          lstrcpy(localCopyResultsNode.reactionType," ");
          memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
          IndexResultsTable++;
        }
			}

			// Valid cue
			if (strlen(DSPlast10Nodes[run].text) &&
          !(DSPlast10Nodes[run].flags & BEENHIGHLIGHTED) &&  // Only once
          DSPlast10Nodes[run].age <= DSPHiAreaExit &&
          DSPlast10Nodes[run].age >= DSPHiAreaEntry)         // Is in highlight area
      {
        TabbedTextOut(hdc,
                      DSPClientRect.left,
                      DSPClientRect.bottom-DSPlast10Nodes[run].age,
                      DSPlast10Nodes[run].text,
                      strlen(DSPlast10Nodes[run].text),
                      1,
                      &CXTabSpace,
                      0);

        DSPlast10Nodes[run].flags |= BEENHIGHLIGHTED;

        // SNDPROMPT-requests and protocol
        if (DSPlast10Nodes[run].flags & TRUELOUDTARGETHIGHLIGHT)
        {
          if (!ThisIsACalibrationRun)
          {
            sndPlaySound(LpszPromptSound,SND_ASYNC|SND_MEMORY); // Sound-prompt
          }

          localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
          localCopyResultsNode.videoTC = BCDVideoTime;
          lstrcpy(localCopyResultsNode.text,"DROPPED LOUDTARGETHIGHLIGHT");
          lstrcpy(localCopyResultsNode.reactionType," ");
          memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
          IndexResultsTable++;
        }

        if (DSPlast10Nodes[run].flags & SILENTTARGETHIGHLIGHT)
        {
          // no cue for subject
          localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
          localCopyResultsNode.videoTC = BCDVideoTime;
          lstrcpy(localCopyResultsNode.text,"DROPPED SILENTTARGETHIGHLIGHT");
          lstrcpy(localCopyResultsNode.reactionType," ");
          memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
          IndexResultsTable++;
        }

        if (DSPlast10Nodes[run].flags & LOUDDISTRACTHIGHLIGHT)
        {
          if (!ThisIsACalibrationRun)
          {
            sndPlaySound(LpszPromptSound,SND_ASYNC|SND_MEMORY); // Invalid cue
          }

          localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
          localCopyResultsNode.videoTC = BCDVideoTime;
          lstrcpy(localCopyResultsNode.text,"DROPPED LOUDDISTRACTHIGHLIGHT");
          lstrcpy(localCopyResultsNode.reactionType," ");
          memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
          IndexResultsTable++;
        }

        if (DSPlast10Nodes[run].flags & SILENTDISTRACTHIGHLIGHT)
        {
          // no cue for subject
          localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
          localCopyResultsNode.videoTC = BCDVideoTime;
          lstrcpy(localCopyResultsNode.text,"DROPPED SILENTDISTRACTHIGHLIGHT");
          lstrcpy(localCopyResultsNode.reactionType," ");
          memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
          IndexResultsTable++;
        }
      }
    }

		//Not supported, dynamic traffic events can be detected offline from video tape recording.
    //Experimenter is too busy to judge events online.  
		//if (TSTRspoiledSituation)
		//{
		//	localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
    //  localCopyResultsNode.videoTC = BCDVideoTime;
    //  lstrcpy(localCopyResultsNode.text,"EXPERT SEES DYNAMIC EVENT");
    //  lstrcpy(localCopyResultsNode.reactionType," ");
    //  memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
    //  IndexResultsTable++;
		//	TSTRspoiledSituation = FALSE;
		//}

    SetTextColor(hdc,PALETTEINDEX(CALGRAY_PINDEX)); // Back to normal color

    for(run=0;run<10;run++)
    {
      if (strlen(DSPlast10Nodes[run].text) &&
          !(DSPlast10Nodes[run].flags & BEENRENORMALIZED) && // Only once
          DSPlast10Nodes[run].age >= DSPHiAreaExit)          // Floated out of highlight area
      {
        TabbedTextOut(hdc,
                      DSPClientRect.left,
                      DSPClientRect.bottom-DSPlast10Nodes[run].age,
                      DSPlast10Nodes[run].text,
                      strlen(DSPlast10Nodes[run].text),
                      1,
                      &CXTabSpace,
                      0);

        DSPlast10Nodes[run].flags |= BEENRENORMALIZED;
      }
    }

    if (countDown == 0) // after AWAITNTIMERS*TIMERINTERVAL msec
    {
      countDown=AWAITNTIMERS;
    }

    if (!ThisIsADemoRun && !ThisIsACalibrationRun)
    {
      if (TerminatingPress())
      {
        TrialEndDetected = TRUE;  // Set end-of-trial flag
      }

      BCDLastVideoTime = BCDVideoTime; // Anachronistic
    }
    else
    {
      if ((timeGetTime() - startTimeOfCurrentRun) > MSECsDemoRunLength)
      {
        ThisIsADemoRun=FALSE;     // Ends now
        TrialEndDetected = TRUE;  // Set end-of-trial flag
      }
    }

    WaitMSECS(MSECsInterScrollDelayWINI); // WaitMSECS detects notifications via RS232

    // Target situation
    if ((highLightedTarget=DSPlast10NodesHasHiLightTarget(&indexOfHLT)) == TRUE) // Hit possible
    {
      if (TSTRvp)
      {
        // Write HIT DETECTED to results table
        localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
        localCopyResultsNode.videoTC = BCDVideoTime;
        lstrcpy(localCopyResultsNode.text,DSPlast10Nodes[indexOfHLT].text);
        lstrcpy(localCopyResultsNode.reactionType,"HIT");
        memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
        IndexResultsTable++;

        if (!ThisIsACalibrationRun)
        {
          sndPlaySound(LpszHitSound,SND_ASYNC|SND_MEMORY);
        }
        // Killed target becomes black
        SetTextColor(hdc,RGB(0,0,0));
        TabbedTextOut(hdc,
                      DSPClientRect.left,
                      DSPClientRect.bottom-DSPlast10Nodes[indexOfHLT].age,
                      DSPlast10Nodes[indexOfHLT].text,
                      strlen(DSPlast10Nodes[indexOfHLT].text),
                      1,
                      &CXTabSpace,
                      0);

        DSPlast10Nodes[indexOfHLT].flags |= BEENDEADCOLORED;
      }
    }
    else  // No hit possible
    {
      if (TSTRvp)
      {
        // False alarm detected
        localCopyResultsNode.runTime = timeGetTime() - startTimeOfCurrentRun;
        localCopyResultsNode.videoTC = BCDVideoTime;
        lstrcpy(localCopyResultsNode.text,"NO TARGET IN CRITICAL SECTION");
        lstrcpy(localCopyResultsNode.reactionType,"FALSE ALARM");
        memcpy(CollectedResults+IndexResultsTable,(HP_RESULTSNODE)&localCopyResultsNode,sizeof(RESULTSNODE));
        IndexResultsTable++;

        if (!ThisIsACalibrationRun)
        {
         	sndPlaySound(LpszFalseAlarmSound,SND_ASYNC|SND_MEMORY);
        }
      }
    }

    SelectObject(hdc,hFntBackup);
    SelectPalette(hdc,oldPalette,FALSE);
    EndPaint(HWNDDispChild,&ps);
  }

  // Subject answer flag back to false
  TSTRvp = FALSE;
}

void ShiftDSPlast10Nodes(void)
{
  memmove(DSPlast10Nodes+1,DSPlast10Nodes,9*sizeof(TEXTDISPLAYNODE));
}

void AgingDSPlast10Nodes(void)
{
  int i;

  for(i=0;i<10;i++)
    DSPlast10Nodes[i].age++;
}

void cwCenter(HWND hWnd,int top)
{
  POINT pt;
  RECT swp;
  RECT rParent;
  int iwidth;
  int iheight;

  // Get the rectangles for the parent and the child
  GetWindowRect(hWnd,&swp);
  GetClientRect(hWndMain,&rParent);

  // Calculate the height and width for MoveWindow
  iwidth=swp.right-swp.left;
  iheight=swp.bottom-swp.top;

  // Find the center point and convert to screen coordinates
  pt.x=(rParent.right-rParent.left)/2;
  pt.y=(rParent.bottom-rParent.top)/2;
  ClientToScreen(hWndMain,&pt);

  // Calculate the new x,y starting point
  pt.x=pt.x-(iwidth/2);
  pt.y=pt.y-(iheight/2);

  // Top will adjust the window position, up or down
  if(top)
    pt.y=pt.y+top;

  MoveWindow(hWnd,pt.x,pt.y,iwidth,iheight,FALSE);
}

BOOL DSPlast10NodesHasHiLightTarget(int *atIndex)
{
  int i;

  for(i=0;i<10;i++)
  {
    if (((DSPlast10Nodes[i].flags & PREMATUREWARNEDTARGETHIGHLIGHT) || (DSPlast10Nodes[i].flags & TRUELOUDTARGETHIGHLIGHT) || (DSPlast10Nodes[i].flags & SILENTTARGETHIGHLIGHT)) && 
        (DSPlast10Nodes[i].flags & BEENHIGHLIGHTED) &&   
        !(DSPlast10Nodes[i].flags & BEENRENORMALIZED) && 
        !(DSPlast10Nodes[i].flags & BEENDEADCOLORED))    
    {
      *atIndex = i;
      return TRUE; // At least one critical string is in target position
    }
  }

  return FALSE;
}

BOOL Ask4COM1Notifications(void)
{
  if (IDYES == MessageBox(NULL,"Input via COM1 ?","Task2 must know:",MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON1))
  {
    return TRUE;
  }

  return FALSE;
}

int LoadMemImagesOfSounds(void)
{
  long fileLen;                // Size of wave file in bytes
  HMMIO hmmio;                 // MMSYSTEM-file handle
  static char szFileName[256]; // File name buffer
  long mmioReadRet;            // mmioRead return value

  // Prompt sound
  lstrcpy(szFileName,"ICPROMPT.WAV");

  if ((fileLen=TellFileLength(szFileName)) > 65536)
  {
    LoadString(hInst,IDS_ERR_LoadMemImagesOfS_0,szString,sizeof(szString));
    MessageBox(NULL,szFileName,szString,MB_ICONEXCLAMATION);
    return -1;
  }

  if ((HPromptSound=GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE|GMEM_ZEROINIT,fileLen)) == NULL)
  {
    goto ALLOC_ERR;
  }
  else
  {
    if ((LpszPromptSound=(char *)GlobalLock(HPromptSound)) == NULL)
    {
      goto LOCK_ERR;
    }
  }

  if (!mmioOpen(szFileName,NULL,MMIO_EXIST))
  {
    MessageBox(NULL,szFileName,"Folgende bentigte Datei existiert nicht:",MB_ICONHAND|MB_OK);
    return -1;
  }
  else
  {
    if ((hmmio=mmioOpen(szFileName,NULL,MMIO_READ)) == NULL)
    {
      goto OPEN_ERR;
    }
    else
    {
      if ((mmioReadRet=mmioRead(hmmio,(HPSTR)LpszPromptSound,fileLen)) == -1)
      {
        goto READ_ERR;
      }
      else
      {
        mmioClose(hmmio,0);
      }
    }
  }

  // Hit-sound
  lstrcpy(szFileName,"ICHIT.WAV");

  if ((fileLen=TellFileLength(szFileName)) > 65536)
  {
    LoadString(hInst,IDS_ERR_LoadMemImagesOfS_0,szString,sizeof(szString));
    MessageBox(NULL,szFileName,szString,MB_ICONEXCLAMATION);
    return -1;
  }

  if ((HHitSound=GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE|GMEM_ZEROINIT,fileLen)) == NULL)
  {
    goto ALLOC_ERR;
  }
  else
  {
    if ((LpszHitSound=(char *)GlobalLock(HHitSound)) == NULL)
    {
      goto LOCK_ERR;
    }
  }

  if (!mmioOpen(szFileName,NULL,MMIO_EXIST))
  {
    MessageBox(NULL,szFileName,"Folgende bentigte Datei existiert nicht:",MB_ICONHAND|MB_OK);
    return -1;
  }
  else
  {
    if ((hmmio=mmioOpen(szFileName,NULL,MMIO_READ)) == NULL)
    {
      goto OPEN_ERR;
    }
    else
    {
      if ((mmioReadRet=mmioRead(hmmio,(HPSTR)LpszHitSound,fileLen)) == -1)
      {
        goto READ_ERR;
      }
      else
      {
        mmioClose(hmmio,0);
      }
    }
  }

  // False-alarm sound
  lstrcpy(szFileName,"ICFALSE.WAV");

  if ((fileLen=TellFileLength(szFileName)) > 65536)
  {
    LoadString(hInst,IDS_ERR_LoadMemImagesOfS_0,szString,sizeof(szString));
    MessageBox(NULL,szFileName,szString,MB_ICONEXCLAMATION);
    return -1;
  }

  if ((HFalseAlarmSound=GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE|GMEM_ZEROINIT,fileLen)) == NULL)
  {
    goto ALLOC_ERR;
  }
  else
  {
    if ((LpszFalseAlarmSound=(char *)GlobalLock(HFalseAlarmSound)) == NULL)
    {
      goto LOCK_ERR;
    }
  }

  if (!mmioOpen(szFileName,NULL,MMIO_EXIST))
  {
    MessageBox(NULL,szFileName,"Folgende bentigte Datei existiert nicht:",MB_ICONHAND|MB_OK);
    return -1;
  }
  else
  {
    if ((hmmio=mmioOpen(szFileName,NULL,MMIO_READ)) == NULL)
    {
      goto OPEN_ERR;
    }
    else
    {
      if ((mmioReadRet=mmioRead(hmmio,(HPSTR)LpszFalseAlarmSound,fileLen)) == -1)
      {
        goto READ_ERR;
      }
      else
      {
        mmioClose(hmmio,0);
      }
    }
  }

  return 1;  // success

  // Handling of possible errors

ALLOC_ERR:
  LoadString(hInst,IDS_ERR_LoadMemImagesOfS_1,szString,sizeof(szString));
  MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
  return -1;

LOCK_ERR:
  LoadString(hInst,IDS_ERR_LoadMemImagesOfS_2,szString,sizeof(szString));
  MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
  return -1;

OPEN_ERR:
  LoadString(hInst,IDS_ERR_LoadMemImagesOfS_3,szString,sizeof(szString));
  MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
  return -1;

READ_ERR:
  LoadString(hInst,IDS_ERR_LoadMemImagesOfS_4,szString,sizeof(szString));
  MessageBox(NULL,szString,NULL,MB_ICONEXCLAMATION);
  return -1;
}

// 65536 indicates errors
long TellFileLength(char *name)
{
  long filesLength;
  int hFile = open(name,O_RDONLY);

  if (hFile == -1) // Problem to be handled by caller
    return 65536;

  if ((filesLength=filelength(hFile)) == -1L) 
    return 65536;  // Problem to be handled by caller

  close(hFile);

  return filesLength;
}

// Plug in a palette at HLogicalPalette
void MakeColorPalette(void)
{
  LOCALHANDLE hlgpalObject;
  LOGPALETTE *plgpal;
  PALETTEENTRY iaminserted;

  // Only three colors needed
  hlgpalObject=LocalAlloc(LMEM_FIXED,sizeof(LOGPALETTE)+(3-1)*sizeof(PALETTEENTRY));
  plgpal=(LOGPALETTE *)LocalLock(hlgpalObject);
  plgpal->palNumEntries=3;
  plgpal->palVersion=0x300; // Das reicht

  iaminserted.peRed   = (BYTE)220;      // Subjective impression: same luminance as pure green
  iaminserted.peGreen = (BYTE)220;      
  iaminserted.peBlue  = (BYTE)220;
  iaminserted.peFlags = PC_RESERVED;
  plgpal->palPalEntry[0]=iaminserted;   // 0 == CALGRAY_PINDEX

  iaminserted.peRed   = (BYTE)0;
  iaminserted.peGreen = (BYTE)255;
  iaminserted.peBlue  = (BYTE)0;
  iaminserted.peFlags = PC_RESERVED;
  plgpal->palPalEntry[1]=iaminserted;   // 1 == PUREGREEN_PINDEX

  iaminserted.peRed   = (BYTE)255;
  iaminserted.peGreen = (BYTE)255;
  iaminserted.peBlue  = (BYTE)128;
  iaminserted.peFlags = PC_RESERVED;
  plgpal->palPalEntry[2]=iaminserted;   // 2 == PALEYELLOW_PINDEX

  // Create GDI palette object
  HLogicalPalette=CreatePalette(plgpal);
  // Release memory
  LocalUnlock(hlgpalObject);
  LocalFree(hlgpalObject);
}


BOOL InterpretationOfTCString(INTFORMTC *itc,char *tcString)
{
  static char szDropCode[12];
  char szSt[] = {'0','0','\0'};  // If tokenization does not fill all first_glimpse.timecode
  char szMi[] = {'0','0','\0'};  // elements, we assume a value of 00
  char szSe[] = {'0','0','\0'};
  char szFr[] = {'0','0','\0'};

  if (strlen(tcString) != 11)
  {
ILLSPEC:
    MessageBox(NULL,"Timecode must be in the form XX:XX:XX:XX","Impossible timecode format",MB_OK|MB_ICONHAND);
    return FALSE;
  }

  lstrcpy(szDropCode,tcString); // Copy it, strtok modifies its argument

  strcpy(szSt,strtok(szDropCode,":,;./"));   // Tokenization
  strcpy(szMi,strtok(NULL,":,;./"));
  strcpy(szSe,strtok(NULL,":,;./"));
  strcpy(szFr,strtok(NULL,"!"));

  if (lstrlen(szSt) < 2 || lstrlen(szMi) < 2 || lstrlen(szSe) < 2 || lstrlen(szFr) < 2)
  {
    goto ILLSPEC;
  }


  itc->intSt = atoi(szSt);
  itc->intMi = atoi(szMi);
  itc->intSe = atoi(szSe);
  itc->intFr = atoi(szFr);

  // Detect nonsense values
  if (itc->intSt > 99 || itc->intMi > 59 || itc->intSe > 59 || itc->intFr > 24)
  {
    char msg[64];

    sprintf(msg,"Nonsense value %02d:%02d:%02d:%02d detected",itc->intSt,itc->intMi,itc->intSe,itc->intFr);
    MessageBox(NULL,msg,"Impossible timecode",MB_OK|MB_ICONHAND);
    return FALSE;
  }

  return TRUE;
}

// Writes gathered data to file at end of trial
void WriteoutGatheredData(void)
{
  static RESULTSNODE localCopyResultsNode;  
  long slotIndex = 0;
  static char feedBackMsg[256];

	if (GloCountSegments != GloNumExpectedSegments)
	{
		sprintf(feedBackMsg,"Warning, %d segments -- expected %d from analysis of target material file",GloCountSegments,GloNumExpectedSegments);
		fprintf(Results,feedBackMsg);
		fprintf(Results,"\nPossible problem detected\n");
		MessageBox(NULL,feedBackMsg,"Problem",MB_OK);
	}

	fprintf(Results,"AtSecond\tAtVidTC\tStimulus\tReaction\n");

	while (slotIndex < NUMBEROFRESULTSLOTS)
	{
		memcpy((HP_RESULTSNODE)&localCopyResultsNode,CollectedResults+slotIndex,sizeof(RESULTSNODE));

		if (localCopyResultsNode.reactionType[0] == '\0') // The last used slot + 1
		{
			break;
		}
		else
		{
			fprintf(Results,
							"%.3lf\t%02x:%02x:%02x:%02x\t%s\t%s\n",
							(double)localCopyResultsNode.runTime/1000.,
							localCopyResultsNode.videoTC.bcdSt,
							localCopyResultsNode.videoTC.bcdMi,
							localCopyResultsNode.videoTC.bcdSe,
							localCopyResultsNode.videoTC.bcdFr,
							localCopyResultsNode.text,
							localCopyResultsNode.reactionType);
			slotIndex++;
		}
	}

  if (fclose(Results) == 0)
  {
    sndPlaySound ("Danke.wav",SND_SYNC);
    sprintf(feedBackMsg,"%s is the results file",SzResultsFile);
    MessageBox(NULL,feedBackMsg,"Backup your data and backup your backups !",MB_OK|MB_ICONINFORMATION);
  }

  PostMessage(hWndMain,WM_CLOSE,0,0L);
}

BOOL TerminatingPress(void)
{
	if (GloCountSegments == GloNumExpectedSegments)
	{
		return TRUE;
	}
	else
	{
		return FALSE; 
	}
}

// Only of 'historical' interest 
// Zur Entprellung ist jeder Taster nach Auslsung fr einige Zeit gesperrt
//void TSTRSenseKeys(BOOL init)
//{
//	static DWORD timeOfLastHitTSTRvp;                 // Zeit des letzten Hits VP-Taster
//	static DWORD timeOfLastHitTSTRnextSituation;      // Zeit des letzten Hits VL-Taster
//	static DWORD timeOfLastHitTSTRspoiledSituation;   // Zeit des letzten Hits Situationswarner
//
//	if (init) // Mu einmal beim Programmstart aufgerufen werden!
//	{
//		timeOfLastHitTSTRvp = timeOfLastHitTSTRnextSituation = timeOfLastHitTSTRspoiledSituation = timeGetTime();
//	}
//	else
//	{
//		unsigned val = (unsigned) _inp(0x378+1);
//
//		// Shift logic is for Win32 API only
//		if (!((val << 28) >> 31)) // Bit 3 auf 0 gezogen == groer roter Taster (Vp)
//		{
//	 		if ((timeGetTime() - timeOfLastHitTSTRvp) > 1000)
//			{
//				TSTRvp = TRUE;
//				timeOfLastHitTSTRvp = timeGetTime();
//			}
//		}
//	 
//		if (!((val << 27) >> 31)) // Bit 4 auf 0 gezogen == kleiner grner Taster (Vl)
//		{
//	 		if ((timeGetTime() - timeOfLastHitTSTRnextSituation) > 1500)
//			{
//				BYTE userBits[8];      // Userbits-Array fr den TCI-50I
//				char inter[3];         // Zwischenpuffer
//				
//				TSTRnextSituation = TRUE;
//				timeOfLastHitTSTRnextSituation = timeGetTime();
//				// globalen Situationszhler inkrementieren
//				GloCountSegments++;
//				
//				// Versuchsbedingung achtfach redundant in den Userbits vermerken (BCD-Format)
//				wsprintf(inter,"33"); 
//				userBits[0] = inter[0];
//				userBits[1] = inter[1];
//				userBits[2] = inter[0];
//				userBits[3] = inter[1];
//				userBits[4] = inter[0];
//				userBits[5] = inter[1];
//				userBits[6] = inter[0];
//				userBits[7] = inter[1];
//				TCI50IUserbitsSetzen(userBits); // 8 mal die 3 fr's Player-Display bedeutet Ablenkung
//
//				if (GloCountSegments <= 79) // Der 80. beendet nur noch den Versuch
//				{
//					// Toggle Voltage to Heading Control Car (On/Off)
//					if (ToggleHCVoltage)
//					{
//						ToggleHCVoltage = FALSE;
//						_outp(0x378,0x00);
//					}
//					else
//					{
//						ToggleHCVoltage = TRUE;
//						_outp(0x378,0xFF);
//					}
//				}
//			}
//		}
//	 
//		if (!((val << 26) >> 31)) // Bit 5 auf 0 gezogen == kleiner roter Taster
//		{
//			if ((timeGetTime() - timeOfLastHitTSTRspoiledSituation) > 1500)
//			{
//				TSTRspoiledSituation = TRUE;
//				timeOfLastHitTSTRspoiledSituation = timeGetTime();
//			}
//		}
//	}
//}

void TSTRSenseKeys(BOOL init)
{
	static DWORD timeOfLastHitTSTRvp;                 // Zeit des letzten Hits VP-Taster
	static DWORD timeOfLastHitTSTRnextSituation;      // Zeit des letzten Hits VL-Taster
  static char lastReceivedKey;
  static DWORD dwRead;
  static DWORD dwRes;

	if (init) // Mu einmal beim Programmstart aufgerufen werden!
	{
		timeOfLastHitTSTRvp = timeOfLastHitTSTRnextSituation = timeGetTime();
	}
	else
	{
    if (!FWaitingOnRead) 
    {
      // Issue read operation.
      if (!ReadFile(GloSerialHandle,&lastReceivedKey,1,&dwRead,&OsReader)) 
      {
        if (GetLastError() != ERROR_IO_PENDING)     // Read not delayed?
        {
          MessageBox(hWndMain,"Error #1","TSTRSenseKeys",MB_OK);  
        }   
        else
        {
          FWaitingOnRead = TRUE;
        }
      }
    } // else read completed immediately
    else 
    {
      dwRes = WaitForSingleObject(OsReader.hEvent,READ_TIMEOUT);

      switch(dwRes)
      {
        // Read completed.
        case WAIT_OBJECT_0:
             if (!GetOverlappedResult(GloSerialHandle,&OsReader,&dwRead,FALSE))
             {
               MessageBox(hWndMain,"Error #2","TSTRSenseKeys",MB_OK);   
             }
             // else read completed successfully.

             //  Reset flag so that another opertion can be issued.
             FWaitingOnRead = FALSE;
             break;

        case WAIT_TIMEOUT:
             // Operation isn't complete yet. fWaitingOnRead flag isn't
             // changed since I'll loop back around, and I don't want
             // to issue another read until the first one finishes.
             break;                       

        default:
             {
               MessageBox(hWndMain,"Error #3","TSTRSenseKeys",MB_OK);   
             } // This indicates a problem with the OVERLAPPED structure's
               // event handle.
             break;
      }
    }

		if (lastReceivedKey == 't') // Subject responded
		{
	 		if ((timeGetTime() - timeOfLastHitTSTRvp) > 1000) // Against panicy subjects 
			{
				TSTRvp = TRUE;
				timeOfLastHitTSTRvp = timeGetTime();
			}

      lastReceivedKey = 'n'; // Nothing to be done
		}
	 
		if (lastReceivedKey == '#') // New segment from primitive situation detector
		{
	 		if ((timeGetTime() - timeOfLastHitTSTRnextSituation) > 100)
			{
				TSTRnextSituation = TRUE;
				timeOfLastHitTSTRnextSituation = timeGetTime();
				GloCountSegments++;
      }

      lastReceivedKey = 'n'; // Nothing to be done
    }
	}
}

BOOL ManipulationAllowed(void)
{
	if (PERMISSION_DENIED)
	{
	  MessageBox(hWndMain,"Robust working version does not allow this feature","Permission denied",MB_OK);
	  return FALSE;
	}

	return TRUE;
}

void STCStartSimulatedTC(void)
{
	STCstartTime = timeGetTime();
}

void STCGeneratePseudoTC(DWORD timeNow,DWORD STCstartTime,TIMEONLY *fillMe)
{
	DWORD offSet = timeNow - STCstartTime;
	DWORD offSetInFrames = offSet / 40;    // A frame is 40 msec long
	DWORD dwHours;
	DWORD dwMinutes;
	DWORD dwSeconds;
	DWORD dwFrames;

	dwHours = offSetInFrames / 90000;
	fillMe->bcdSt = Integer2BCD(dwHours);

	dwMinutes = (offSetInFrames % 90000) / 1500;
	fillMe->bcdMi = Integer2BCD(dwMinutes);

	dwSeconds = ((offSetInFrames % 90000) % 1500) / 25;
	fillMe->bcdSe = Integer2BCD(dwSeconds);

	dwFrames = (((offSetInFrames % 90000) % 1500) % 25);
	fillMe->bcdFr = Integer2BCD(dwFrames);
}

BYTE Integer2BCD(DWORD integer)
{
	char buf[3];
	BYTE result;

	if (integer > 99)
	{
		MessageBox(NULL,"Cannot convert values > 99","Integer2BCD",MB_ICONHAND|MB_OK);
		return 0x99;
	}

	sprintf(buf,"%02lu",integer);
	fillLowNibble(&result,buf[1]);
	fillHighNibble(&result,buf[0]);

	return result;
}

// Warning: also zeroes the high nibble
void fillLowNibble(BYTE *bcd_targetbyte,char sourceNumber)
{
  *bcd_targetbyte=0x00;

  switch (sourceNumber)
  {
    case '0': *bcd_targetbyte=0x0;  // 00000000
              break;
    case '1': *bcd_targetbyte=0x1;  // 00000001
              break;
    case '2': *bcd_targetbyte=0x2;  // 00000010
              break;
    case '3': *bcd_targetbyte=0x3;  // 00000011
              break;
    case '4': *bcd_targetbyte=0x4;  // 00000100
              break;
    case '5': *bcd_targetbyte=0x5;  // 00000101
              break;
    case '6': *bcd_targetbyte=0x6;  // 00000110
              break;
    case '7': *bcd_targetbyte=0x7;  // 00000111
              break;
    case '8': *bcd_targetbyte=0x8;  // 00001000
              break;
    case '9': *bcd_targetbyte=0x9;  // 00001001
              break;
  }
}

// This function writes only to the high nibble
void fillHighNibble(BYTE *bcd_targetbyte,char sourceNumber)
{
  switch (sourceNumber)
  {
    case '0': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x00); // 0000
              break;
    case '1': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x10); // 0001
		          break;
    case '2': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x20); // 0010
              break;
    case '3': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x30); // 0011
              break;
    case '4': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x40); // 0100
              break;
    case '5': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x50); // 0101
              break;
    case '6': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x60); // 0110
              break;
    case '7': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x70); // 0111
              break;
    case '8': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x80); // 1000
              break;
    case '9': *bcd_targetbyte=(*bcd_targetbyte|(BYTE)0x90); // 1001
              break;
  }
}

BOOL RandomBinaryDecision(BOOL justInit)
{
	if (justInit) // Initialization call 
	{
		srand((unsigned)time(NULL));
		return FALSE;
	}
	else // Usage
	{
		if (rand() % 2)	
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
}

BOOL OpenSerialCommunication(LPSTR comName)
{
  static DCB dcb; // A device control block

  if (lstrlen(comName) != 5)
  {
    MessageBox(NULL,"Argument must consist of 5, e.g. COM1:","OpenSerialCommunication",MB_ICONHAND|MB_OK);
    return FALSE;
  }
  else
  {
    lstrcpy(GloComName,comName);
  }

	GloSerialHandle = CreateFile(GloComName,                // Checked
	                          GENERIC_READ | GENERIC_WRITE, // Because the generator has an unidirectional serial
						                0,                            // No sharing
						                0,                            // Handle not inherited to child processes (ignored under Win95)
						                OPEN_EXISTING,                // Must be OPEN_EXISTING for communication resources 
						                FILE_FLAG_OVERLAPPED,         // See Allen Denver, Technical Article
						                0);                           // Always

	if (GloSerialHandle == INVALID_HANDLE_VALUE)
	{
		MessageBox(NULL,"Cannot open communication","OpenSerialCommunication",MB_ICONHAND|MB_OK);
		return FALSE;
	}

  // Configure COMx
  if (GetCommState(GloSerialHandle,&dcb) < 0)
  {
    MessageBox(NULL,"Unable to read settings","OpenSerialCommunication GetCommState error",MB_ICONHAND|MB_OK);
    return FALSE;
  }

  dcb.BaudRate=CBR_9600;
  dcb.fBinary=TRUE;
  dcb.fParity=FALSE;
	dcb.fOutxCtsFlow=FALSE;
  dcb.fOutxDsrFlow=FALSE;
  dcb.fDtrControl=DTR_CONTROL_DISABLE;
	dcb.fDsrSensitivity=FALSE;
	dcb.fTXContinueOnXoff=FALSE;
  dcb.fOutX=FALSE;
  dcb.fInX=FALSE;
	dcb.fErrorChar=FALSE;
  dcb.fNull=FALSE;
  dcb.fRtsControl=RTS_CONTROL_DISABLE; 
	dcb.fAbortOnError=FALSE;
	dcb.ByteSize=8;
  dcb.Parity=NOPARITY;
  dcb.StopBits=ONESTOPBIT;

  if (SetCommState(GloSerialHandle,&dcb) < 0)
  {
    MessageBox(NULL,"Unable to set communication device","OpenSerialCommunication",MB_ICONHAND|MB_OK);
    return FALSE;
  }

  // Create the overlapped event. Must be closed before exiting
  // to avoid a handle leak.
  OsReader.hEvent = CreateEvent(NULL,TRUE,FALSE,NULL);

  if (OsReader.hEvent == NULL)
  {
    MessageBox(NULL,"Error creating overlapped event","OpenSerialCommunication",MB_ICONEXCLAMATION|MB_OK);
  }

  return TRUE;
}

void ShutDownSerialCommunication(void)
{
  if (!CloseHandle(OsReader.hEvent))
  {
    MessageBox(NULL,"Cannot close event handle","ShutDownSerialCommunication",MB_ICONEXCLAMATION|MB_OK);
  }
  
  if (!CloseHandle(GloSerialHandle))
  {
    MessageBox(NULL,"Cannot close serial interface","ShutDownSerialCommunication",MB_ICONEXCLAMATION|MB_OK);
  }
}

